/* Extract Paramater Map from Sigma Studio anjd load in here.
   Use these to initialise an array of the offsets for the 
   parameters for the AD1940 */  


const int Atten_Map[8] =  /* [Band 0,0,1,1,2,2,3,3]*/
{
	MOD_B0_VOL_ALG0_GAINALGNS145X1GAIN_ADDR,  	
    MOD_B0_VOL_ALG0_GAINALGNS145X1GAIN_ADDR,  
	MOD_B1_VOL_ALG0_GAINALGNS145X2GAIN_ADDR, 
	MOD_B1_VOL_ALG0_GAINALGNS145X2GAIN_ADDR,
	MOD_B2_VOL_ALG0_GAINALGNS145X3GAIN_ADDR,
	MOD_B2_VOL_ALG0_GAINALGNS145X3GAIN_ADDR,
	MOD_B3_VOL_ALG0_GAINALGNS145X4GAIN_ADDR,
	MOD_B3_VOL_ALG0_GAINALGNS145X4GAIN_ADDR
};



const int Invert_Map[8] =  /* [Band 0,0,1,1,2,2,3,3]*/
{
	MOD_B0_INV_0_GAINALGNS145X7GAIN_ADDR,  	
    MOD_B0_INV_1_GAINALGNS145X8GAIN_ADDR,  
	MOD_B1_INV_0_GAINALGNS145X5GAIN_ADDR, 
	MOD_B1_INV_1_GAINALGNS145X6GAIN_ADDR,
	MOD_B2_INV_0_GAINALGNS145X9GAIN_ADDR,
	MOD_B2_INV_1_GAINALGNS145X10GAIN_ADDR,
	MOD_B3_INV_0_GAINALGNS145X11GAIN_ADDR,
	MOD_B3_INV_1_GAINALGNS145X12GAIN_ADDR
};



/* Use an array to reference the addresses for the IIR Filter Parameters - allows a single funtion 
   to sort out all the addresses and adata values */
const int Filter_Map[4][2][4][5] =  /* [Band] [Fh, Fl] [Filter1, Filter2, Filter3, Filter4] [b0, b1, b2, a1, a2] */
{
	{ { {MOD_B0_LPF0_ALG0_STAGE0_B0_ADDR,  MOD_B0_LPF0_ALG0_STAGE0_B1_ADDR,  MOD_B0_LPF0_ALG0_STAGE0_B2_ADDR,  MOD_B0_LPF0_ALG0_STAGE0_A1_ADDR,  MOD_B0_LPF0_ALG0_STAGE0_A2_ADDR},  
		{MOD_B0_LPF1_ALG0_STAGE0_B0_ADDR,  MOD_B0_LPF1_ALG0_STAGE0_B1_ADDR,  MOD_B0_LPF1_ALG0_STAGE0_B2_ADDR,  MOD_B0_LPF1_ALG0_STAGE0_A1_ADDR,  MOD_B0_LPF1_ALG0_STAGE0_A2_ADDR},  
		{MOD_B0_LPF2_ALG0_STAGE0_B0_ADDR,  MOD_B0_LPF2_ALG0_STAGE0_B1_ADDR,  MOD_B0_LPF2_ALG0_STAGE0_B2_ADDR,  MOD_B0_LPF2_ALG0_STAGE0_A1_ADDR,  MOD_B0_LPF2_ALG0_STAGE0_A2_ADDR},  
		{MOD_B0_LPF3_ALG0_STAGE0_B0_ADDR,  MOD_B0_LPF3_ALG0_STAGE0_B1_ADDR,  MOD_B0_LPF3_ALG0_STAGE0_B2_ADDR,  MOD_B0_LPF3_ALG0_STAGE0_A1_ADDR,  MOD_B0_LPF3_ALG0_STAGE0_A2_ADDR}}, 
	  { {MOD_B0_HPF0_ALG0_STAGE0_B0_ADDR,  MOD_B0_HPF0_ALG0_STAGE0_B1_ADDR,  MOD_B0_HPF0_ALG0_STAGE0_B2_ADDR,  MOD_B0_HPF0_ALG0_STAGE0_A1_ADDR,  MOD_B0_HPF0_ALG0_STAGE0_A2_ADDR},  
		{MOD_B0_HPF1_ALG0_STAGE0_B0_ADDR,  MOD_B0_HPF1_ALG0_STAGE0_B1_ADDR,  MOD_B0_HPF1_ALG0_STAGE0_B2_ADDR,  MOD_B0_HPF1_ALG0_STAGE0_A1_ADDR,  MOD_B0_HPF1_ALG0_STAGE0_A2_ADDR},  
		{MOD_B0_HPF2_ALG0_STAGE0_B0_ADDR,  MOD_B0_HPF2_ALG0_STAGE0_B1_ADDR,  MOD_B0_HPF2_ALG0_STAGE0_B2_ADDR,  MOD_B0_HPF2_ALG0_STAGE0_A1_ADDR,  MOD_B0_HPF2_ALG0_STAGE0_A2_ADDR},  
		{MOD_B0_HPF3_ALG0_STAGE0_B0_ADDR,  MOD_B0_HPF3_ALG0_STAGE0_B1_ADDR,  MOD_B0_HPF3_ALG0_STAGE0_B2_ADDR,  MOD_B0_HPF3_ALG0_STAGE0_A1_ADDR,  MOD_B0_HPF3_ALG0_STAGE0_A2_ADDR}} },   /* Band0 */	
    { { {MOD_B1_LPF0_ALG0_STAGE0_B0_ADDR,  MOD_B1_LPF0_ALG0_STAGE0_B1_ADDR,  MOD_B1_LPF0_ALG0_STAGE0_B2_ADDR,  MOD_B1_LPF0_ALG0_STAGE0_A1_ADDR,  MOD_B1_LPF0_ALG0_STAGE0_A2_ADDR},  
		{MOD_B1_LPF1_ALG0_STAGE0_B0_ADDR,  MOD_B1_LPF1_ALG0_STAGE0_B1_ADDR,  MOD_B1_LPF1_ALG0_STAGE0_B2_ADDR,  MOD_B1_LPF1_ALG0_STAGE0_A1_ADDR,  MOD_B1_LPF1_ALG0_STAGE0_A2_ADDR},  
		{MOD_B1_LPF2_ALG0_STAGE0_B0_ADDR,  MOD_B1_LPF2_ALG0_STAGE0_B1_ADDR,  MOD_B1_LPF2_ALG0_STAGE0_B2_ADDR,  MOD_B1_LPF2_ALG0_STAGE0_A1_ADDR,  MOD_B1_LPF2_ALG0_STAGE0_A2_ADDR},  
		{MOD_B1_LPF3_ALG0_STAGE0_B0_ADDR,  MOD_B1_LPF3_ALG0_STAGE0_B1_ADDR,  MOD_B1_LPF3_ALG0_STAGE0_B2_ADDR,  MOD_B1_LPF3_ALG0_STAGE0_A1_ADDR,  MOD_B1_LPF3_ALG0_STAGE0_A2_ADDR}}, 
      { {MOD_B1_HPF0_ALG0_STAGE0_B0_ADDR,  MOD_B1_HPF0_ALG0_STAGE0_B1_ADDR,  MOD_B1_HPF0_ALG0_STAGE0_B2_ADDR,  MOD_B1_HPF0_ALG0_STAGE0_A1_ADDR,  MOD_B1_HPF0_ALG0_STAGE0_A2_ADDR},  
		{MOD_B1_HPF1_ALG0_STAGE0_B0_ADDR,  MOD_B1_HPF1_ALG0_STAGE0_B1_ADDR,  MOD_B1_HPF1_ALG0_STAGE0_B2_ADDR,  MOD_B1_HPF1_ALG0_STAGE0_A1_ADDR,  MOD_B1_HPF1_ALG0_STAGE0_A2_ADDR},  
		{MOD_B1_HPF2_ALG0_STAGE0_B0_ADDR,  MOD_B1_HPF2_ALG0_STAGE0_B1_ADDR,  MOD_B1_HPF2_ALG0_STAGE0_B2_ADDR,  MOD_B1_HPF2_ALG0_STAGE0_A1_ADDR,  MOD_B1_HPF2_ALG0_STAGE0_A2_ADDR},  
		{MOD_B1_HPF3_ALG0_STAGE0_B0_ADDR,  MOD_B1_HPF3_ALG0_STAGE0_B1_ADDR,  MOD_B1_HPF3_ALG0_STAGE0_B2_ADDR,  MOD_B1_HPF3_ALG0_STAGE0_A1_ADDR,  MOD_B1_HPF3_ALG0_STAGE0_A2_ADDR}} },   /* Band1 */
	{ { {MOD_B2_LPF0_ALG0_STAGE0_B0_ADDR,  MOD_B2_LPF0_ALG0_STAGE0_B1_ADDR,  MOD_B2_LPF0_ALG0_STAGE0_B2_ADDR,  MOD_B2_LPF0_ALG0_STAGE0_A1_ADDR,  MOD_B2_LPF0_ALG0_STAGE0_A2_ADDR},  
		{MOD_B2_LPF1_ALG0_STAGE0_B0_ADDR,  MOD_B2_LPF1_ALG0_STAGE0_B1_ADDR,  MOD_B2_LPF1_ALG0_STAGE0_B2_ADDR,  MOD_B2_LPF1_ALG0_STAGE0_A1_ADDR,  MOD_B2_LPF1_ALG0_STAGE0_A2_ADDR},  
		{MOD_B2_LPF2_ALG0_STAGE0_B0_ADDR,  MOD_B2_LPF2_ALG0_STAGE0_B1_ADDR,  MOD_B2_LPF2_ALG0_STAGE0_B2_ADDR,  MOD_B2_LPF2_ALG0_STAGE0_A1_ADDR,  MOD_B2_LPF2_ALG0_STAGE0_A2_ADDR},  
		{MOD_B2_LPF3_ALG0_STAGE0_B0_ADDR,  MOD_B2_LPF3_ALG0_STAGE0_B1_ADDR,  MOD_B2_LPF3_ALG0_STAGE0_B2_ADDR,  MOD_B2_LPF3_ALG0_STAGE0_A1_ADDR,  MOD_B2_LPF3_ALG0_STAGE0_A2_ADDR}}, 
	  { {MOD_B2_HPF0_ALG0_STAGE0_B0_ADDR,  MOD_B2_HPF0_ALG0_STAGE0_B1_ADDR,  MOD_B2_HPF0_ALG0_STAGE0_B2_ADDR,  MOD_B2_HPF0_ALG0_STAGE0_A1_ADDR,  MOD_B2_HPF0_ALG0_STAGE0_A2_ADDR},  
		{MOD_B2_HPF1_ALG0_STAGE0_B0_ADDR,  MOD_B2_HPF1_ALG0_STAGE0_B1_ADDR,  MOD_B2_HPF1_ALG0_STAGE0_B2_ADDR,  MOD_B2_HPF1_ALG0_STAGE0_A1_ADDR,  MOD_B2_HPF1_ALG0_STAGE0_A2_ADDR},  
		{MOD_B2_HPF2_ALG0_STAGE0_B0_ADDR,  MOD_B2_HPF2_ALG0_STAGE0_B1_ADDR,  MOD_B2_HPF2_ALG0_STAGE0_B2_ADDR,  MOD_B2_HPF2_ALG0_STAGE0_A1_ADDR,  MOD_B2_HPF2_ALG0_STAGE0_A2_ADDR},  
		{MOD_B2_HPF3_ALG0_STAGE0_B0_ADDR,  MOD_B2_HPF3_ALG0_STAGE0_B1_ADDR,  MOD_B2_HPF3_ALG0_STAGE0_B2_ADDR,  MOD_B2_HPF3_ALG0_STAGE0_A1_ADDR,  MOD_B2_HPF3_ALG0_STAGE0_A2_ADDR}} },   /* Band2 */
	{ { {MOD_B3_LPF0_ALG0_STAGE0_B0_ADDR,  MOD_B3_LPF0_ALG0_STAGE0_B1_ADDR,  MOD_B3_LPF0_ALG0_STAGE0_B2_ADDR,  MOD_B3_LPF0_ALG0_STAGE0_A1_ADDR,  MOD_B3_LPF0_ALG0_STAGE0_A2_ADDR},  
		{MOD_B3_LPF1_ALG0_STAGE0_B0_ADDR,  MOD_B3_LPF1_ALG0_STAGE0_B1_ADDR,  MOD_B3_LPF1_ALG0_STAGE0_B2_ADDR,  MOD_B3_LPF1_ALG0_STAGE0_A1_ADDR,  MOD_B3_LPF1_ALG0_STAGE0_A2_ADDR},  
		{MOD_B3_LPF2_ALG0_STAGE0_B0_ADDR,  MOD_B3_LPF2_ALG0_STAGE0_B1_ADDR,  MOD_B3_LPF2_ALG0_STAGE0_B2_ADDR,  MOD_B3_LPF2_ALG0_STAGE0_A1_ADDR,  MOD_B3_LPF2_ALG0_STAGE0_A2_ADDR},  
		{MOD_B3_LPF3_ALG0_STAGE0_B0_ADDR,  MOD_B3_LPF3_ALG0_STAGE0_B1_ADDR,  MOD_B3_LPF3_ALG0_STAGE0_B2_ADDR,  MOD_B3_LPF3_ALG0_STAGE0_A1_ADDR,  MOD_B3_LPF3_ALG0_STAGE0_A2_ADDR}}, 
	  { {MOD_B3_HPF0_ALG0_STAGE0_B0_ADDR,  MOD_B3_HPF0_ALG0_STAGE0_B1_ADDR,  MOD_B3_HPF0_ALG0_STAGE0_B2_ADDR,  MOD_B3_HPF0_ALG0_STAGE0_A1_ADDR,  MOD_B3_HPF0_ALG0_STAGE0_A2_ADDR}, 
		{MOD_B3_HPF1_ALG0_STAGE0_B0_ADDR,  MOD_B3_HPF1_ALG0_STAGE0_B1_ADDR,  MOD_B3_HPF1_ALG0_STAGE0_B2_ADDR,  MOD_B3_HPF1_ALG0_STAGE0_A1_ADDR,  MOD_B3_HPF1_ALG0_STAGE0_A2_ADDR}, 
		{MOD_B3_HPF2_ALG0_STAGE0_B0_ADDR,  MOD_B3_HPF2_ALG0_STAGE0_B1_ADDR,  MOD_B3_HPF2_ALG0_STAGE0_B2_ADDR,  MOD_B3_HPF2_ALG0_STAGE0_A1_ADDR,  MOD_B3_HPF2_ALG0_STAGE0_A2_ADDR}, 
		{MOD_B3_HPF3_ALG0_STAGE0_B0_ADDR,  MOD_B3_HPF3_ALG0_STAGE0_B1_ADDR,  MOD_B3_HPF3_ALG0_STAGE0_B2_ADDR,  MOD_B3_HPF3_ALG0_STAGE0_A1_ADDR,  MOD_B3_HPF3_ALG0_STAGE0_A2_ADDR}} }     /* Band4 */
};

const int Delay_Map[4] =  /* [Band] */
{
	MOD_BO_DEL_DELAYAMT_ADDR,  /* Band 0 */
	MOD_B1_DEL_DELAYAMT_ADDR,  /* Band 1 */
	MOD_B2_DEL_DELAYAMT_ADDR,  /* Band 2 */
	MOD_B3_DEL_DELAYAMT_ADDR   /* Band 3 */
};

const int Para_Filter_Map[15][5] =  /* [Band 0_0,1,2 Band 1_0,1,2 Band 2_0,1,2 Band 3_0,1,2 G0, G1, G2] [b0, b1, b2, a1, a2] */
{   
	{MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB212_ADDR,   MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB211_ADDR,   MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB210_ADDR,   MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB214_ADDR,  MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB213_ADDR},
	{MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB212_ADDR,   MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB211_ADDR,   MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB210_ADDR,   MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB214_ADDR,  MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB213_ADDR},
	{MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB212_ADDR,   MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB211_ADDR,   MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB210_ADDR,   MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB214_ADDR,  MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB213_ADDR},
	{MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB212_ADDR,      MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB211_ADDR,      MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB210_ADDR,      MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB214_ADDR,     MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB213_ADDR},	
	{MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB212_ADDR,      MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB211_ADDR,      MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB210_ADDR,      MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB214_ADDR,     MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB213_ADDR},	
	{MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB212_ADDR,      MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB211_ADDR,      MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB210_ADDR,      MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB214_ADDR,     MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB213_ADDR},	
	{MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB212_ADDR,      MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB211_ADDR,      MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB210_ADDR,      MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB214_ADDR,     MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB213_ADDR},	
	{MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB212_ADDR,      MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB211_ADDR,      MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB210_ADDR,      MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB214_ADDR,     MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB213_ADDR},	
	{MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB212_ADDR,      MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB211_ADDR,      MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB210_ADDR,      MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB214_ADDR,     MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB213_ADDR},	
	{MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB212_ADDR,     MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB211_ADDR,     MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB210_ADDR,     MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB214_ADDR,    MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB213_ADDR},	
	{MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB212_ADDR,     MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB211_ADDR,     MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB210_ADDR,     MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB214_ADDR,    MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB213_ADDR},	
	{MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB212_ADDR,     MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB211_ADDR,     MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB210_ADDR,     MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB214_ADDR,    MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB213_ADDR},	
	{MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB212_ADDR,     MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB211_ADDR,     MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB210_ADDR,     MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB214_ADDR,    MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB213_ADDR},	
	{MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB212_ADDR,     MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB211_ADDR,     MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB210_ADDR,     MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB214_ADDR,    MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB213_ADDR},	
	{MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB212_ADDR,     MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB211_ADDR,     MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB210_ADDR,     MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB214_ADDR,    MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB213_ADDR},	
};


/* A sicko approximation to dB to linear conversion */
/*
Use 1>>(atten / 6) as a right shift operand to do 6dB steps.
This works fine for 6dB increments.  For increments between, use this lookup table as an approximation

if (remainder == 0)
	Atten = 1 >> (atten / 6)
else
	Atten = 1 >> (atten / 6) - Atten_Shift[remainder] >> (atten/6)

*/
const unsigned char Atten_Shift[12] =  /* offset of 1,2,3,4 and 5 between 6dB steps of attenuation */
{
	0,    /* 0dB more than a 6dB step */
	14,    /* 0.5dB more than a 6dB step */
	28,  /* 1dB more than a 6dB step */
	40,  /* 1.5dB more than a 6dB step */
	53,  /* 2dB more than a 6dB step */
	64,  /* 2.5dB more than a 6dB step */
	75,  /* 3dB more than a 6dB step */
	85,  /* 3.5dB more than a 6dB step */
	95,  /* 4dB more than a 6dB step */
	103,  /* 4.5dB more than a 6dB step */
	112,  /* 5dB more than a 6dB step */
	120  /* 5.5dB more than a 6dB step */
};

/******************************************************************************/
/* this is totally legacy from about 2005 when using a tiny pic for AD1940    */
/******************************************************************************/
const unsigned char Atten_Shift_Para[25] =  /* offset of 1,2,3,4 and 5 between 6dB steps of attenuation */
{
	255,   		/* Full on 	*/
	240,
	227,			
	215,
	203,
	191,  		
	181,
	170,
	161,
	152,
	143,
	135,	
	128,
	121,
	114,
	108,
	102,
	96,
	90,
	85,		
	81,
	76,  		
	72,
	68,
	64
};

#define INPUT_SEL_MCH_SPDIF_ADC             MOD_INPUT_SEL_MCH_SPDIF_ADC_STEREOMUXSIGMA300NS4INDEX_ADDR
#define MONITOR_SEL_SPDIF_ADC               MOD_MONITOR_SEL_SPDIF_ADC_STEREOMUXSIGMA300NS2INDEX_ADDR 
//#define Bridge_Switch_0                     MOD_BRIDGE_SW_ALG0_STEREOMUXSIGMA3001VOL00_ADDR
//#define Bridge_Switch_1                     MOD_BRIDGE_SW_ALG0_STEREOMUXSIGMA3001VOL01_ADDR

